% Section 5.6.2 Case 2: Output Feedback
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System 
R0 = 1.2; L0 = 0.05; Kv = 0.6; Km = 0.6; J0 = 0.1352; B0 = 0.3;
d_Km = 0.01; d_Kv = 0.01;

A = [-R0/L0  -Kv/L0; Km/J0  -B0/J0]; 
B = [1/L0; 0]; 
Fa = [1/(10*L0); 0]; 
D = [0;1]; 
C = eye(2); 
Fs = [-1;2];

% Uncertainty
Delta_A = [0 d_Kv;d_Km  0];

% Design FE observer and FTC controller
alpha1 = d_Km; beta1 = d_Kv;
Mc = eye(2);
Fc = [d_Kv/alpha1 0; 0 d_Km/beta1];
Nc = [0 alpha1; beta1 0];

[Kx,M,G,L,H,betao,gammao] = Observer_controller_design(A,B,Fa,D,C,Fs,Mc,Nc)

% Define global variables to store data
global Int_ffa Int_ffs Int_yy1 Int_yy2 Int_ts Int_count Int_tmp Int_hatfa Int_hatfs Int_s
global Ints_ts Ints_count Ints_tmp Ints_hatfa Ints_hatfs Ints_yy1 Ints_yy2 Ints_s
global Intn_ts Intn_count Intn_tmp Intn_hatfa Intn_hatfs Intn_yy1 Intn_yy2

Int_ffa = []; Int_ffs = []; Int_yy1 = []; Int_yy2 = []; Int_ts = []; Int_count = 0; Int_tmp = 0; Int_hatfa = []; Int_hatfs = []; Int_s = [];
Ints_ts = []; Ints_count = 0; Ints_tmp = 0; Ints_hatfa = []; Ints_hatfs = []; Ints_yy1 = []; Ints_yy2 = []; Ints_s = [];
Intn_ts = []; Intn_tmp = 0; Intn_count = 0; Intn_hatfa = []; Intn_hatfs = []; Intn_yy1 = []; Intn_yy2 = [];

% Initial conditon
hat_eta0 = 0;
xi0 = [0;0;0;0];
x0 = [0.5;0.5];
xx0 = [hat_eta0', xi0',x0'];

% Simulation time span
t0 = 0;
tf = 25;
tspan = [t0 tf];

% Solve differential equation
[Int_tt,Int_yy] = ode45(@(t,xx) FTC_closed_sys_performance(t,xx,A,B,Fa,D,C,Fs,Delta_A,Kx,M,G,L,H), tspan,xx0);
Int_x1 = Int_yy(:,6);
Int_x2 = Int_yy(:,7);

[Inn_tt,Inn_yy] = ode45(@(t,xx) Norminal_control_closed_sys_performance(t,xx,A,B,Fa,D,C,Fs,Delta_A,Kx,M,G,L,H), tspan,xx0);

% Draw figures
run('Draw_figures.m');